Scriptname _SLSubmitSavageEffect extends activemagiceffect

_SLSubmitConfig Property _SLConfig auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto
Keyword Property ActorTypeNPC  Auto  
SexLabFramework property SexLab auto

GlobalVariable Property AttemptCost  Auto  
GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
Float Property FailurePenalty  Auto 
GlobalVariable Property _SLSubmitFailurePenalty  Auto  
float Property THealth  Auto
Topic Property _SLSubmitBleedOut Auto

Spell Property _SLSubmitCalm Auto
MagicEffect Property CalmEffect Auto
ReferenceAlias Property ActorVictim  Auto  
Faction Property _SLSubmitFaction Auto
Faction Property _SLSubmitRecoverFaction Auto
Faction Property _SLSubmitBountyFaction Auto

Actor Property PlayerRef Auto

Event OnEffectStart(actor Target, actor Caster)
	If (Target.HasKeyword(ActorTypeNPC) && (Target.IsInCombat() || Target.HasMagicEffect(CalmEffect)))
; // Code for the success algorithm
		Target.GetLeveledActorBase().SetProtected()
		PlayerRef.DamageAV("Stamina",AttemptCost.GetValue())
		THealth = Target.GetAV("Health")/Target.GetBaseAV("Health")*100
		_SLQuest.GatherStats(Target,Caster)
		_SLQuest.ShoutChance()
		If !Caster.IsWeaponDrawn()		
			Caster.DrawWeapon()	
			_SLScene.WRT(0.5)
		EndIf
; // Code for what happens on success
		If (THealth <= 90.0)
			If (SuccessChance.GetValue() >= SuccessRoll.GetValue())
				If (!Target.IsInFaction(_SLSubmitRecoverFaction))
					Target.AddToFaction(_SLSubmitRecoverFaction)
				EndIf
				If (_SLSubmitFailurePenalty.GetValue() > 0.0)
					FailurePenalty = _SLSubmitFailurePenalty.GetValue() - 10
					_SLSubmitFailurePenalty.SetValue(FailurePenalty)
				EndIf
				If(_SLConfig.debugActive)
					Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target submits!")
				EndIf
				ActorVictim.ForceRefTo(Target)
				If (!Target.IsInFaction(_SLSubmitFaction))
					Target.AddToFaction(_SLSubmitFaction)
				EndIf
				_SLSubmitCalm.Cast(Target)
				_SLScene.WRT(0.5)
				Debug.SendAnimationEvent(Target, "BleedOutStart")
				_SLScene.WRT(0.1)
				Target.Say(_SLSubmitBleedOut)
				_SLSubmitCalm.Cast(Target)
				Target.StopCombat()
				If Caster.IsWeaponDrawn()		
					Caster.SheatheWeapon()	
					_SLScene.WRT(0.5)
				EndIf
				_SLScene.WRT(2.0)
				If(PlayerRef.IsTrespassing())
					Target.SetRelationshipRank(PlayerRef,1)
				EndIf
;				Caster.PushActorAway(Target, 0)

				_SLScene.Strip(Target)

				If(_SLConfig.RapeActive)
					_SLScene.WRT(0.5)
					_SLScene.Sex(Target,Caster)
				Else
					_SLScene.PostRob(Target,Caster)
				EndIf
				If (Target.IsInFaction(_SLSubmitRecoverFaction))
					Target.RemoveFromFaction(_SLSubmitRecoverFaction)
				EndIf
				If (!Target.IsInFaction(_SLSubmitBountyFaction) && _SLQuest.IsHostileNPC(Target))
					Target.AddToFaction(_SLSubmitBountyFaction)
				EndIf
			Else
; // Code for what happens on failure
				If (_SLSubmitFailurePenalty.GetValue() < 50.0)
					FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
					_SLSubmitFailurePenalty.SetValue(FailurePenalty)
				EndIf
				If(_SLConfig.debugActive)
					Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target resists!")
				EndIf
			EndIf
		Else
			If (_SLSubmitFailurePenalty.GetValue() < 50.0)
				FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
				_SLSubmitFailurePenalty.SetValue(FailurePenalty)
			EndIf
			If(_SLConfig.debugActive)
				Debug.Notification("Target's health is " + THealth + "% and is over 90%.  Target automatically resists!")
			EndIf
		EndIf
	Else
		If (_SLSubmitFailurePenalty.GetValue() < 50.0)
			FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
			_SLSubmitFailurePenalty.SetValue(FailurePenalty)
		EndIf
		If(_SLConfig.debugActive)
			Debug.Notification("Target is an invalid target.  Target automatically resists!")
		EndIf
	EndIf
EndEvent